clc;clear;

% Q = [3,2,1;
%      2,4,0;
%      1,0,5];
% h = [-24;-48;-130];
% c = -2;

n = 400;
Q = gallery('randcorr',n);
h = randn(n,1);
c = randn;


rng(17) % For reproducibility
% Two sets of random quadratic constraints:
H{1} = gallery('randcorr',n); % Random positive definite matrix
H{2} = gallery('randcorr',n);
k{1} = randn(n,1);
k{2} = randn(n,1);
d{1} = randn;
d{2} = randn;

x0 = randn(n,1);

options = optimoptions(@fmincon,'Algorithm','interior-point',...
    'SpecifyObjectiveGradient',true,'SpecifyConstraintGradient',true,...
    'HessianFcn',@(x,lambda)quadhess(x,lambda,Q,H),'Display','off');%, ...
     %'CheckGradients',true,'FiniteDifferenceType','central');

fun = @(x)quadobj_grad(x,Q,h,c);

nonlconstr = @(x)quadconstr_grad(x,H,k,d);

tic
[x,fval,eflag,output,lambda] = fmincon(fun,x0,...
    [],[],[],[],[],[],nonlconstr,options);
fprintf('Results with all possible inputs, obtained in %.4e seconds \n',toc)
output

%%
fun = @(x)quadobj_no_grad(x,Q,h,c);
nonlconstr = @(x)quadconstr_no_grad(x,H,k,d);
options_no_grad = optimoptions(@fmincon,'Algorithm','interior-point','Display','off');
options_no_grad.MaxFunctionEvaluations = 10000;
tic
[x3,fval3,eflag3,output3,lambda3] = fmincon(fun,x0,...
    [],[],[],[],[],[],nonlconstr,options_no_grad);
fprintf('Results with minimal inputs, obtained in %.4e seconds \n',toc)
output3



